import * as React from "react"
import "./navigation.scss"
import { Navbar, NavbarBrand, Nav, NavItem, NavLink } from "reactstrap"
import logo from "../images/Glitch_White_RGB.png"
import EnvironmentDropdown from "./environmentDropdown"

export default class Navigation extends React.Component<{}, {}> {

  render() {
    return (
      <div>
        <Navbar color="dark" dark expand="md">
          <NavbarBrand href="/">
            <img src={logo} width="30" height="30" id="logo" className="d-inline-block align-top" alt="Twitch Logo"/>
            Browser Grid
          </NavbarBrand>

          <Nav className="ml-auto" navbar>
            <NavItem>
              <NavLink href="/hubs">Hubs</NavLink>
            </NavItem>
            <EnvironmentDropdown />
          </Nav>
        </Navbar>
      </div>
    )
  }
};
