import * as React from "react"
import ReactDOM from 'react-dom';
import 'bootstrap/dist/css/bootstrap.min.css';
import App from './App';
import * as serviceWorker from './serviceWorker';
import { Provider } from "react-redux";
import Store from "./store/store"
import { PersistGate } from 'redux-persist/integration/react'

let reduxStore = Store();

ReactDOM.render(
  <Provider store={reduxStore.store}>
    <PersistGate loading={null} persistor={reduxStore.persistor}>
      <App />
    </PersistGate>
  </Provider>,
  document.getElementById('root')
);

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: https://bit.ly/CRA-PWA
serviceWorker.unregister();
