export const UPDATE_ENVIRONMENT = "UPDATE_ENVIRONMENT";

// Type for updating an environment
export interface UpdateEnvironmentAction {
  type: typeof UPDATE_ENVIRONMENT;
  namePayload: string;
  urlPayload: string;
}

// All environment action types
export type EnvironmentTypes = UpdateEnvironmentAction;

// Updates the environment in redux
// newEnvironment: The environment name to update to
// newUrl: The environment url to update to
export default function updateEnvironment(newEnvironment: string, newUrl: string): EnvironmentTypes {
  return {
    type: UPDATE_ENVIRONMENT,
    namePayload: newEnvironment,
    urlPayload: newUrl,
  }
}
