import { EnvironmentState } from "./types";
import { Environments } from "../../components/environmentDropdown"
import { EnvironmentTypes, UPDATE_ENVIRONMENT } from "./actions"

// The default environment name
const defaultEnvironmentName = "Production";

// The default/initial state
const initialState: EnvironmentState = {
  name: defaultEnvironmentName, // grab the default environment name
  url: Environments[defaultEnvironmentName], // grab the default environment's url
};

// Reducer for environment
export default function environmentReducer(
  state = initialState,
  action: EnvironmentTypes,
): EnvironmentState {
  switch (action.type) {
    case UPDATE_ENVIRONMENT:
      return {
        name: action.namePayload,
        url: action.urlPayload,
      };
    default:
      return state
  }
}
