import { AnyAction, createStore, Store } from "redux";
import rootReducer from "./reducers";
import { devToolsEnhancer } from 'redux-devtools-extension';
import { persistStore, persistReducer, Persistor } from 'redux-persist'
import storage from 'redux-persist/lib/storage' // defaults to localStorage for web

// Set up redux-persist
const persistConfig = {
  key: 'root',
  storage,
};
const persistedReducer = persistReducer(persistConfig, rootReducer);

// export a function that returns the store and redux persistor
export default function (): { store: Store<any, AnyAction>; persistor: Persistor; } {
  let store = createStore(persistedReducer, devToolsEnhancer({}));
  let persistor = persistStore(store);
  return { store, persistor }
}

// Keeps track for all App State
export type AppState = ReturnType<typeof rootReducer>;
