module "base" {
  source = "../modules/base"
}

module "dev" {
  source = "../modules/eb"
  application_name     = module.base.aws_elastic_beanstalk_application.name
  instance_profile_arn = module.base.aws_iam_instance_profile.arn
  service_role_arn     = module.base.BeanstalkServiceRole.arn
  environment = "dev"
  r53_zone    = var.r53_zone_id
  vpc_id      = var.vpc_id
  subnets     = var.subnets
  dns_name    = var.nexus_dns_name
}
