resource "aws_iam_role" "grid_ui" {
  name = "grid_ui"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "grid_ui" {
  name = "grid_ui"
  role = aws_iam_role.grid_ui.name
}

# Add a cloudwatch policy for mon-scripts to post to CloudWatch
# https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mon-scripts.html
resource "aws_iam_policy" "cloudwatch_logs" {
  name        = "grid_ui_cloudwatch_logs"
  path        = "/"
  description = "A policy for writing instance data (memory utilization, etc) to CloudWatch"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "Stmt1535734359418",
      "Action": [
        "cloudwatch:GetMetricStatistics",
        "cloudwatch:ListMetrics",
        "cloudwatch:PutMetricData"
      ],
      "Effect": "Allow",
      "Resource": "*"
    },
    {
      "Sid": "Stmt1535734422775",
      "Action": [
        "ec2:DescribeTags"
      ],
      "Effect": "Allow",
      "Resource": "*"
    }
  ]
}
EOF
}

# Attach the cloudwatch policy to the role
resource "aws_iam_role_policy_attachment" "cloudwatch_attach" {
  role       = "${aws_iam_role.grid_ui.name}"
  policy_arn = "${aws_iam_policy.cloudwatch_logs.arn}"
}

# Allow AWS SSM Access
resource "aws_iam_role_policy_attachment" "ssm" {
  role       = "${aws_iam_role.grid_ui.name}"
  policy_arn = "arn:aws:iam::aws:policy/AmazonSSMManagedInstanceCore"
}
