// Create an IAM Role that allows Jenkins to manage resources
resource "aws_iam_role" "artifacts" {
  name = "jenkins"
  description = "Allows Jenkins to Manage"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::043714768218:role/jenkins-prod-master",
          "arn:aws:iam::043714768218:role/jenkins-prod-slave"
        ]
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

// Manage Beanstalk Versions, and fetch artifacts from the grid-artifacts bucket
resource "aws_iam_role_policy" "manage_beanstalk" {
  name = "Manage-Beanstalk"
  role = aws_iam_role.artifacts.id

  policy = <<-EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "elasticbeanstalk:CreateApplicationVersion",
        "elasticbeanstalk:DescribeApplicationVersions",
        "elasticbeanstalk:DeleteApplicationVersion",
        "elasticbeanstalk:UpdateApplicationVersion"
      ],
      "Effect": "Allow",
      "Resource": "arn:aws:elasticbeanstalk:${data.aws_region.current.name}:${data.aws_caller_identity.current.account_id}:applicationversion/grid-ui/*"
    },
    {
      "Action": "s3:*",
      "Effect": "Allow",
      "Resource": [
        "arn:aws:s3:::elasticbeanstalk-${data.aws_region.current.name}-${data.aws_caller_identity.current.account_id}",
        "arn:aws:s3:::elasticbeanstalk-${data.aws_region.current.name}-${data.aws_caller_identity.current.account_id}/*"
      ]
    }
  ]
}
  EOF
}
