package heimdall


// GetAvailableUserResponse models PUT /types/available/:env
type GetAvailableUserResponse struct {
	Body    HeimdallUser `json:"body"`
	Message string       `json:"message"`
}

// UnlockUserResponse models PUT /types/:type/users/:user/:env/unlock
type UnlockUserResponse struct {
	Body    HeimdallUser `json:"body"`
	Message string       `json:"message"`
}

// HeimdallUser models the user object for PUT /types/available/:env
type HeimdallUser struct {
	Username            string `json:"username"`
	AuthenticationToken string `json:"authentication_token"`
}

// AuthenticationToken models authentication_token object for PUT /types/available/:env
type AuthenticationToken struct {
	AuthToken  AuthToken `json:"authToken"`
	APIToken   string    `json:"apiToken"`
	Persistent string    `json:"persistent"`
	TUID       string    `json:"tuid"`
}

// AuthToken models authToken object in AuthenticationToken
type AuthToken struct {
	AuthToken   string `json:"authToken"`
	DisplayName string `json:"displayName"`
	ID          string `json:"id"`
	Login       string `json:"login"`
}

// User model
type User struct {
	User          HeimdallUser
	Authorization string
	UserID        string
}
