# Heimdall UI

This is the front-end for [Heimdall](https://git.xarth.tv/qe/heimdall).  It is written in `React` and utilizes `Redux` for data management.  It is based off of `version 2.0` of the [React Redux Starter Kit](https://github.com/davezuko/react-redux-starter-kit) (note: current version is quite different).

React, Redux, React-Router, and JavaScript Promises are the major concepts that power this web-app.  If you're unfamiliar with these 3 concepts, then I suggest you check out the links below to get an understanding of how they work:

* [React Documentation](https://facebook.github.io/react/docs/hello-world.html)
* [Redux Documentation](http://redux.js.org/)
* [React-Router Guide](https://github.com/ReactTraining/react-router/tree/master/docs)
* [JavaScript Promises Intro](https://developers.google.com/web/fundamentals/getting-started/primers/promises)

## Requirements
* node `^4.5.0`
* npm `^3.0.0`
* yarn `^0.18.1`

## Installation
Follow the guides below to setup the above requirements:

* [Node & NPM Guide](https://docs.npmjs.com/getting-started/installing-node)
* [Yarn Guide](https://yarnpkg.com/en/docs/install)

After cloning the project, simply run the following in the project directory:

```bash
$ yarn install   # Install project dependencies
$ npm start      # Compile and launch
```

You should be able to access the app at http://localhost:3001 with your web browser.

`npm start` watches any of the files for changes and reloads whenever this happens.  Thus, when developing, the page will reload whenever you make changes to the source code (nifty so you don't have to keep rerunning `npm start`).

While developing, you will probably rely mostly on `npm start`.  That being said, there are additional scripts at your disposal (see `scripts` in `package.json`).  To run any of these, simply run: `npm run <script>`.

## Deployment
You can deploy the app by serving the `~/dist` directory generated by running `npm run deploy:prod`.

## Features

This UI features a `Live Mode`.  By default this is on and will poll the Heimdall server for the status of our locks periodically.  Once a lock is selected, `Live Mode` will be disabled until all locks are unselected.

You can also sort the various columns by toggling their headers.

In addition, you can filter what locks are shown by typing in text in the filter box.

## Design
The application structure presented is **fractal**, where functionality is grouped primarily by feature rather than file type.

```
.
├── bin                      # Build/Start scripts
├── config                   # Project and build configurations
├── public                   # Static public assets (not imported anywhere in source code)
├── server                   # Express application that provides webpack middleware
│   └── main.js              # Server application entry point
├── src                      # Application source code
│   ├── index.html           # Main HTML page container for app
│   ├── main.js              # Application bootstrap and rendering
│   ├── components           # Global Reusable Presentational Components
│   ├── containers           # Global Reusable Container Components
│   ├── layouts              # Components that receive children for each route
│   ├── modules              # Actions and reducers that deal with fetching data from the server
│   ├── routes               # Main route definitions and async split points
│   │   ├── index.js         # Route entry point route
│   │   ├── UserTable        # The main home page, table of users
│   │   │   ├── actions      # Redux actions specific to this route
│   │   │   ├── components   # Presentational React Components
│   │   │   ├── containers   # Redux containers that wrap our Presentational React Components
│   │   │   ├── objects      # Data objects related to this route
│   │   │   └── reducers     # Redux related reducers for storing route specific data
│   ├── store                # Redux-specific pieces
│   │   ├── createStore.js   # Create and instrument redux store
│   │   └── reducers.js      # Reducer registry and injection
│   ├── styles               # Application-wide styles (generally settings)
│   ├── utils                # Utility helper classes
│   ├── views                # Components that dictate major page structure and serve as a base class for routes
```

Although there are many directories and files; for the most part, while developing, you will be working in the `src` directory - particularly within the `src/routes` and `src/modules` which are explained in greater detail below.

### Routes

Simply put, a route is a page in our application.  Everything within a route's directory is what's needed to power that route and bring it to life.  Typically the contents of a route's directory **should not be accessed by other non-child routes** or other parts of the app.  However, routes are welcome to use global stuff such as modules, components, and utils.

### Modules

Modules are anything that alter the Redux state of our application - typically this happens when we make an API call to the server and get back a response.

Recall that in Redux, the store manages our `state` and that our state is nothing more than a JS object with key/value pairs.  Request to handle changes to our application's state are handled via `actions`, while how those changes are received and represented in our state are determined via `reducers`.  A module is simply a collection of actions and reducers.

Note that in our application structure there are both *top-level modules* and *route-level modules*.  State data handled by our top-level modules are available to all routes and components, while anything within a route-level module is restricted to only that route.

For convenience sake, the action and reducers of the modules in routes are collapsed into their directory structure (i.e. there is no modules sub-directory for in a route).

### Containers

A route will direct a url-path to a given react component.  Within that component you can render additional components.  Typically our components (including the root component we route to) are wrapped by a `container`.  A container is nothing more than a *dummy* component that *contains* the component we really want to render.  The container's job is to map values in the Redux state of our app to properties in our components.

By doing this, we reduce the complexity of our components and separate the data-handling from the rendering as best as we can.  This concept is commonly practiced in React development, and you can read more about it [here](https://medium.com/@dan_abramov/smart-and-dumb-components-7ca2f9a7c7d0#.fi16ugdre) and [here](https://medium.com/@learnreact/container-components-c0e67432e005#.frkzv287u).

### Application State (Store)

There are two entries in our `store` that we really care about in our app: `user_table` and `user_data`.  The `user_table` store contains simple data needed to keep track of the state of our UI.  The `user_data` store contains all of the actual User and Lock data that we fetched from the server.

These are stored in the code as `UserType`, `User`, and `UserLock` objects.  The `User` object binds these together by having a reference to an associated `UserType` ID and a reference to a `UserLock` for staging and prod.

## Development

### Developer Tools
* If you find yourself looking for a React IDE, then I'd suggest [Atom](https://atom.io/) with Facebook's [Nuclide](https://nuclide.io/) package.
* I would also highly recommend using the [Redux DevTools Chrome Extension](https://chrome.google.com/webstore/detail/redux-devtools/lmhkpmbekcpmknklioeibfkpmmfibljd) when debugging.

### Styles
Both `.scss` and `.css` file extensions are supported out of the box. After being imported, styles will be processed with [PostCSS](https://github.com/postcss/postcss) for minification and auto-prefixing, and will be extracted to a `.css` file during production builds.
