job {
  name "qe-heimdall-ui"
  using 'TEMPLATE-autobuild'

  logRotator {
    daysToKeep(90)
  }

  scm {
    git {
      remote {
        github 'qe/heimdall-ui', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  wrappers {
    colorizeOutput(colorMap = 'xterm')
    credentialsBinding {
      usernamePassword('AWS_ACCESS_KEY', 'AWS_SECRET_KEY', 'twitch-cape-qe-aws')
    }
    timestamps()
  }
  steps {
    createPassengerArtifact 'heimdall-ui', "\$GIT_COMMIT", 'elasticbeanstalk-us-west-2-425992774280'
  }
}

job {
  name 'qe-heimdall-ui-deploy'
  using 'TEMPLATE-deploy-aws'

  logRotator {
    daysToKeep(90)
  }

  wrappers {
    credentialsBinding {
      usernamePassword('AWS_ACCESS_KEY', 'AWS_SECRET_KEY', 'twitch-cape-qe-aws')
    }
  }

  steps {
    deployElasticBeanstalkArtifact 'heimdall-ui', "\$ENVIRONMENT", "\$GIT_COMMIT"
    cleanBeanstalkArtifacts 'heimdall-ui'
  }

  publishers {
    postBuildTask {
      task('ERROR: Timed out while waiting for command to Complete.', 'exit 1', true)
      task('ERROR: Failed to deploy application.', 'exit 1', true)
    }
  }
}
