import ApiUtil from 'utils/ApiUtil'
import UserType from '../objects/UserType'

export const REQUEST_USER_TYPES = 'REQUEST_USER_TYPES'
export const RECEIVE_USER_TYPES = 'RECEIVE_USER_TYPES'
export const RECEIVE_USER_TYPES_ERROR = 'RECEIVE_USER_TYPES_ERROR'

const requestUserTypes = () => ({
  type: REQUEST_USER_TYPES
})

function receiveUserTypes (jsonEntries) {
  let userTypes = {}
  jsonEntries["body"].forEach((jsonEntry) => {
    const userType = new UserType(jsonEntry)
    userTypes[userType.id] = userType
  })
  return {
    type: RECEIVE_USER_TYPES,
    userTypes
  }
}

function receiveUserTypesError (error) {
  return {
    type: RECEIVE_USER_TYPES_ERROR,
    error: error
  }
}

export function fetchUserTypes () {
  return function (dispatch, getState) {
    dispatch(requestUserTypes())
    return ApiUtil.getUserTypes().then(
      json => dispatch(receiveUserTypes(json))
    )
    .catch(
      (error) => {
        dispatch(receiveUserTypesError(error))
        return Promise.reject(error)
      }
    )
  }
}
