import ApiUtil from 'utils/ApiUtil'
import User from '../objects/User'
import { UserLockState } from '../objects/UserLock'

export const REQUEST_USERS = 'REQUEST_USERS'
export const RECEIVE_USERS = 'RECEIVE_USERS'
export const RECEIVE_USERS_ERROR = 'RECEIVE_USERS_ERROR'

function requestUsers () {
  return {
    type: REQUEST_USERS
  }
}

function receiveUsers (jsonEntries) {
  let users = {}
  jsonEntries["body"].forEach((jsonEntry) => {
    const user = new User(jsonEntry)
    users[user.id] = user
  })
  return {
    type: RECEIVE_USERS,
    users
  }
}

function receiveUsersError (error) {
  return {
    type: RECEIVE_USERS_ERROR,
    error: error
  }
}

export function fetchUsers () {
  return function (dispatch, getState) {
    dispatch(requestUsers())
    return ApiUtil.getUsers().then(
      json => dispatch(receiveUsers(json))
    ).catch(
      (error) => {
        dispatch(receiveUsersError(error))
        return Promise.reject(error)
      }
    )
  }
}

export const REQUEST_SET_USER_LOCK = 'REQUEST_SET_USER_LOCK'
export const RECEIVE_SET_USER_LOCK = 'RECEIVE_SET_USER_LOCK'
export const RECEIVE_SET_USER_LOCK_STALE = 'RECEIVE_SET_USER_LOCK_STALE'
export const RECEIVE_SET_USER_LOCK_ERROR = 'RECEIVE_SET_USER_LOCK_ERROR'

function requestSetUserLock (userId, lockType, lockState) {
  return {
    type: REQUEST_SET_USER_LOCK,
    userId,
    lockType,
    lockState
  }
}

function receiveSetUserLock (userId, lockType) {
  return {
    type: RECEIVE_SET_USER_LOCK,
    userId,
    lockType
  }
}

function receiveSetUserLockStale (userId, lockType) {
  return {
    type: RECEIVE_SET_USER_LOCK_STALE,
    userId,
    lockType
  }
}

function receiveSetUserLockError (error) {
  console.log(error)
  return {
    type: RECEIVE_SET_USER_LOCK_ERROR,
    error: error
  }
}

export function setUserLock (userType, user, lockType, lockState) {
  return function (dispatch, getState) {
    dispatch(requestSetUserLock(user.id, lockType, lockState))
    const lockValue = (lockState === UserLockState.LOCKED) ? 'lock' : 'unlock'
    return ApiUtil.putUserLock(userType.name, user.name, lockType.name.toLowerCase(), lockValue)
    .then((json) => {
      dispatch(receiveSetUserLock(user.id, lockType))
    }
    ).catch((error) => {
      if (error.status === 422) {
        dispatch(receiveSetUserLockStale(user.id, lockType))
      } else {
        dispatch(receiveSetUserLockError(error))
      }
    })
  }
}
