import UserLock from './UserLock'

export default class User {
  constructor (json) {
    this.id = `${json.id}`
    this.name = json.username
    this.dateCreated = json.created_at
    this.dateUpdated = json.updated_at
    this.userTypeId = json.user_type_id
    this.locks = {}
    json.locks.forEach((lockJson) => {
      const lock = new UserLock(lockJson)
      this.locks[lock.type] = lock
    })
  }

  getUserType (userTypes) {
    return userTypes[this.userTypeId]
  }
}
