import { Enum } from 'enumify'

export class UserLockType extends Enum {}

UserLockType.initEnum([
  'PROD',
  'STAGING'
])

export class UserLockState extends Enum {}

UserLockState.initEnum([
  'LOCKED',
  'UNLOCKED',
  'PENDING'
])

export class UserLockToggleStatus extends Enum {}

UserLockToggleStatus.initEnum([
  'PENDING',
  'SUCCESS',
  'STALE',
  'FAILED',
  'NONE'
])

export default class UserLock {
  constructor (json) {
    this.id = `${json.id}`
    this.userId = json.user_id
    this.jobName = json.job_name
    this.testId = json.test_id
    this.threadId = json.thread_id
    this.dateCreated = json.created_at
    this.dateUpdated = json.updated_at
    this.type = (json.env === 'staging') ? UserLockType.STAGING : UserLockType.PROD
    this.state = (json.state) ? UserLockState.LOCKED : UserLockState.UNLOCKED
    this.toggleStatus = UserLockToggleStatus.NONE
    this.selected = false
  }
}
