import { combineReducers } from 'redux'
import {
  REQUEST_USER_TYPES,
  RECEIVE_USER_TYPES,
  REQUEST_USERS,
  RECEIVE_USERS,
  REQUEST_SET_USER_LOCK,
  RECEIVE_SET_USER_LOCK,
  RECEIVE_SET_USER_LOCK_STALE,
  RECEIVE_SET_USER_LOCK_ERROR
} from '../actions'
import { UserLockToggleStatus } from '../objects/UserLock'

const userTypes = (state = {}, action) => {
  switch (action.type) {
    case REQUEST_USER_TYPES:
      return state
    case RECEIVE_USER_TYPES:
      return action.userTypes
    default:
      return state
  }
}

const users = (state = {}, action) => {
  switch (action.type) {
    case REQUEST_USERS:
      return state
    case RECEIVE_USERS:
      return Object.assign({}, state, action.users)
    case REQUEST_SET_USER_LOCK:
      let newState = Object.assign({}, state)
      newState[action.userId].locks[action.lockType].toggleStatus = UserLockToggleStatus.PENDING
      return newState
    case RECEIVE_SET_USER_LOCK:
      newState = Object.assign({}, state)
      newState[action.userId].locks[action.lockType].toggleStatus = UserLockToggleStatus.SUCCESS
      return newState
    case RECEIVE_SET_USER_LOCK_STALE:
      newState = Object.assign({}, state)
      newState[action.userId].locks[action.lockType].toggleStatus = UserLockToggleStatus.STALE
      return newState
    case RECEIVE_SET_USER_LOCK_ERROR:
      newState = Object.assign({}, state)
      newState[action.userId].locks[action.lockType].toggleStatus = UserLockToggleStatus.FAILED
      return newState
    default:
      return state
  }
}

export default combineReducers({
  userTypes,
  users
})
