import { fetchUserTypes, fetchUsers, setUserLock } from 'modules/user_data/actions'
import { UserLockState } from 'modules/user_data/objects/UserLock'

export const REQUEST_USER_TABLE_ROUTE = 'REQUEST_USER_TABLE_ROUTE'
export const requestUserTableRoute = () => {
  return {
    type: REQUEST_USER_TABLE_ROUTE
  }
}

export const RECEIVE_USER_TABLE_ROUTE = 'RECEIVE_USER_TABLE_ROUTE'
export const receiveUserTableRoute = () => {
  return {
    type: RECEIVE_USER_TABLE_ROUTE
  }
}

export const RECEIVE_USER_TABLE_ROUTE_ERROR = 'RECEIVE_USER_TABLE_ROUTE_ERROR'
export const receiveUserTableRouteError = (error) => {
  return {
    type: RECEIVE_USER_TABLE_ROUTE_ERROR,
    error: error
  }
}

export function fetchUserTableRoute () {
  return function (dispatch, getState) {
    dispatch(requestUserTableRoute())
    Promise.all([
      dispatch(fetchUserTypes()),
      dispatch(fetchUsers())
    ])
    .then(() => {
      return dispatch(receiveUserTableRoute())
    })
    .catch(
      (error) => {
        dispatch(receiveUserTableRouteError(error))
        return Promise.reject(error)
      }
    )
  }
}

export const REQUEST_TOGGLE_USER_LOCKS = 'REQUEST_TOGGLE_USER_LOCKS'
export const requestToggleUserLocks = () => {
  return {
    type: REQUEST_TOGGLE_USER_LOCKS
  }
}

export const RECEIVE_TOGGLE_USER_LOCKS = 'RECEIVE_TOGGLE_USER_LOCKS'
export const receiveToggleUserLocks = () => {
  return {
    type: RECEIVE_TOGGLE_USER_LOCKS
  }
}

export const RECEIVE_TOGGLE_USER_LOCKS_ERROR = 'RECEIVE_TOGGLE_USER_LOCKS_ERROR'
export const receiveToggleUserLocksError = (error) => {
  return {
    type: RECEIVE_TOGGLE_USER_LOCKS_ERROR,
    error: error
  }
}

export function toggleUserLocks (toggleDatum) {
  return function (dispatch, getState) {
    dispatch(requestToggleUserLocks())
    let tasks = []
    toggleDatum.forEach((toggleData) => {
      console.log(toggleData)
      const user = toggleData[0]
      const userType = toggleData[1]
      const lockType = toggleData[2]
      let lockAction = UserLockState.LOCKED
      if (user.locks[lockType].state === UserLockState.LOCKED) {
        lockAction = UserLockState.UNLOCKED
      }
      tasks.push(dispatch(setUserLock(userType, user, lockType, lockAction)))
    })
    Promise.all(tasks)
    .then(() => {
      return dispatch(receiveToggleUserLocks())
    })
    .catch((error) => {
      dispatch(receiveToggleUserLocksError(error))
      return Promise.reject(error)
    })
  }
}
