import React from 'react'
import { UserLockState } from 'modules/user_data/objects/UserLock'
import {
  Glyphicon,
  Table,
  Button,
  Modal
} from 'react-bootstrap'

export default class ToggleConfirmModal extends React.Component {

  constructor (props) {
    super(props)
    this.state = {
      disableButtons: false
    }
    this.onConfirm = this.onConfirm.bind(this)
    this.onCancel = this.onCancel.bind(this)
  }

  onConfirm () {
    this.onCancel()
    this.props.onConfirm()
  }

  onCancel () {
    this.props.onCancel()
  }

  renderLockStateChange (curLockState, nextLockState) {
    function renderLockState (lockState) {
      return (
        <span className={(lockState === UserLockState.LOCKED) ? 'lock_status_locked' : 'lock_status_unlocked'}>
          {lockState.name.toLowerCase()}
        </span>
      )
    }
    return (
      <table>
        <tbody>
          <tr>
            <td style={{ width: '65px' }}>
              {renderLockState(curLockState)}
            </td>
            <td style={{ width: '16px', paddingLeft: '10px', paddingRight: '10px' }}>
              <Glyphicon glyph='arrow-right' />
            </td>
            <td style={{ width: '65px' }}>
              {renderLockState(nextLockState)}
            </td>
          </tr>
        </tbody>
      </table>
    )
  }

  render () {
    console.log('render')
    let modalRows = []
    let nextLockStatusTotals = {}
    nextLockStatusTotals[UserLockState.LOCKED] = 0
    nextLockStatusTotals[UserLockState.UNLOCKED] = 0
    this.props.selectedUserLocks.forEach((pair) => {
      const user = this.props.users[pair[0]]
      const lockType = pair[1]
      const curLockState = user.locks[lockType].state
      const nextLockState = (curLockState === UserLockState.LOCKED) ? UserLockState.UNLOCKED : UserLockState.LOCKED
      nextLockStatusTotals[nextLockState] += 1
      modalRows.push(
        <tr key={`${user.id}_${lockType.name}`}>
          <td>{user.name}</td>
          <td>{lockType.name.toLowerCase()}</td>
          <td>{this.renderLockStateChange(curLockState, nextLockState)}</td>
        </tr>
      )
    })

    return (
      <Modal show={this.props.isVisible} backdrop='static'>
        <Modal.Header>
          <Modal.Title>Toggle Selected Locks</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          <p>This will toggle <b>{this.props.selectedUserLocks.length} locks</b> altering their states like so:</p>
          <ul>
            <li>{nextLockStatusTotals[UserLockState.LOCKED]} locks will be locked</li>
            <li>{nextLockStatusTotals[UserLockState.UNLOCKED]} locks will be unlocked</li>
          </ul>
          <Table striped>
            <thead>
              <tr>
                <th>User</th>
                <th>Lock Type</th>
                <th>State Change</th>
              </tr>
            </thead>
            <tbody>
              {modalRows}
            </tbody>
          </Table>
        </Modal.Body>
        <Modal.Footer>
          <Button onClick={this.onCancel} disabled={this.state.disableButtons}>Cancel</Button>
          <Button bsStyle='primary' onClick={this.onConfirm} disabled={this.state.disableButtons}>Continue</Button>
        </Modal.Footer>
      </Modal>
    )
  }
}

ToggleConfirmModal.propTypes = {
  onConfirm: React.PropTypes.func,
  onCancel: React.PropTypes.func,
  isVisible: React.PropTypes.bool,
  users: React.PropTypes.object,
  selectedUserLocks: React.PropTypes.array
}
