import React from 'react'
import ToggleConfirmModal from './ToggleConfirmModal'
import { UserLockState, UserLockToggleStatus } from 'modules/user_data/objects/UserLock'
import Loading from 'react-loading'
import {
  Glyphicon,
  Table,
  Button,
  Modal
} from 'react-bootstrap'

export default class ToggleProgessModal extends ToggleConfirmModal {

  constructor (props) {
    super(props)
    this.renderToggleStatus = this.renderToggleStatus.bind(this)
  }

  onConfirm () {
    this.props.onConfirm()
  }

  onCancel () {
    // On cancel does nothing.
  }

  renderToggleStatus (user, lockType) {
    const lock = user.locks[lockType]
    if (lock.toggleStatus === UserLockToggleStatus.PENDING) {
      return (<Loading type='spin' color={'#000000'} height='16px' width='16px' />)
    } else if (lock.toggleStatus === UserLockToggleStatus.SUCCESS) {
      return (<Glyphicon className='lock_status_unlocked' glyph='ok-sign' />)
    } else if (lock.toggleStatus === UserLockToggleStatus.STALE) {
      return (<Glyphicon className='lock_status_stale' glyph='exclamation-sign' />)
    } else if (lock.toggleStatus === UserLockToggleStatus.FAILED) {
      return (<Glyphicon className='lock_status_locked' glyph='remove-sign' />)
    } else {
      return null
    }
  }

  render () {
    let modalRows = []
    let nextLockStatusTotals = {}
    nextLockStatusTotals[UserLockState.LOCKED] = 0
    nextLockStatusTotals[UserLockState.UNLOCKED] = 0
    this.props.selectedUserLocks.forEach((pair) => {
      const user = this.props.users[pair[0]]
      const lockType = pair[1]
      const curLockState = user.locks[lockType].state
      const nextLockState = (curLockState === UserLockState.LOCKED) ? UserLockState.UNLOCKED : UserLockState.LOCKED
      nextLockStatusTotals[nextLockState] += 1
      modalRows.push(
        <tr key={`${user.id}_${lockType.name}`}>
          <td>{user.name}</td>
          <td>{lockType.name.toLowerCase()}</td>
          <td>{this.renderLockStateChange(curLockState, nextLockState)}</td>
          <td>{this.renderToggleStatus(user, lockType)}</td>
        </tr>
      )
    })
    return (
      <Modal show={this.props.isVisible} backdrop='static'>
        <Modal.Header>
          <Modal.Title>Toggle Selected Locks</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          <Table striped>
            <thead>
              <tr>
                <th>User</th>
                <th>Lock Type</th>
                <th>State Change</th>
                <th><Glyphicon glyph='transfer' /></th>
              </tr>
            </thead>
            <tbody>
              {modalRows}
            </tbody>
          </Table>
        </Modal.Body>
        <Modal.Footer>
          <Button onClick={this.onConfirm} disabled={this.props.isToggling}>Ok</Button>
        </Modal.Footer>
      </Modal>
    )
  }
}

ToggleProgessModal.propTypes = {
  onConfirm: React.PropTypes.func,
  isVisible: React.PropTypes.bool,
  isToggling: React.PropTypes.bool,
  users: React.PropTypes.object,
  selectedUserLocks: React.PropTypes.array
}
