import React from 'react'
import { UserLockType, UserLockState } from 'modules/user_data/objects/UserLock'
import { Glyphicon, ProgressBar } from 'react-bootstrap'

export default class UserLockBars extends React.Component {
  render () {
    const lockTotals = this.props.lockStatusTotals
    const prodTotalUnlocked = lockTotals[UserLockType.PROD][UserLockState.UNLOCKED]
    const prodTotalLocked = lockTotals[UserLockType.PROD][UserLockState.LOCKED]
    const prodTotal = prodTotalUnlocked + prodTotalLocked
    const prodPercentUnlocked = (prodTotalUnlocked / prodTotal) * 100
    const prodPercentLocked = (prodTotalLocked / prodTotal) * 100
    const stagingTotalUnlocked = lockTotals[UserLockType.STAGING][UserLockState.UNLOCKED]
    const stagingTotalLocked = lockTotals[UserLockType.STAGING][UserLockState.LOCKED]
    const stagingTotal = stagingTotalUnlocked + stagingTotalLocked
    const stagingPercentUnlocked = (stagingTotalUnlocked / stagingTotal) * 100
    const stagingPercentLocked = (stagingTotalLocked / stagingTotal) * 100

    let prodStr = `${prodTotal} Accounts, ${prodPercentUnlocked.toFixed()}% available`
    let prodBar = (
      <ProgressBar>
        <ProgressBar bsStyle='danger' now={prodPercentLocked} label={prodTotalLocked} key={1} />
        <ProgressBar bsStyle='success' now={prodPercentUnlocked} label={prodTotalUnlocked} key={2} />
      </ProgressBar>
    )
    if (prodTotal === 0) {
      prodStr = 'Nothing Selected'
      prodBar = <ProgressBar striped bsStyle='warning' now={100} />
    }
    let stagingStr = `${stagingTotal} Accounts, ${stagingPercentUnlocked.toFixed()}% available`
    let stagingBar = (
      <ProgressBar>
        <ProgressBar bsStyle='danger' now={stagingPercentLocked} label={stagingTotalLocked} key={1} />
        <ProgressBar bsStyle='success' now={stagingPercentUnlocked} label={stagingTotalUnlocked} key={2} />
      </ProgressBar>
    )
    if (stagingTotal === 0) {
      stagingStr = 'Nothing Selected'
      stagingBar = <ProgressBar striped bsStyle='warning' now={100} />
    }
    return (
      <table style={{ width: '100%' }}>
        <tbody>
          <tr>
            <td style={{ width: '50%', paddingRight: '10px' }}>
              <b>
                <Glyphicon glyph='lock' /> Production - {prodStr}
              </b>
              {prodBar}
            </td>
            <td style={{ width: '50%' }}>
              <b>
                <Glyphicon glyph='lock' /> Staging - {stagingStr}
              </b>
              {stagingBar}
            </td>
          </tr>
        </tbody>
      </table>
    )
  }
}

UserLockBars.propTypes = {
  lockStatusTotals: React.PropTypes.object
}
