import React from 'react'
import User from 'modules/user_data/objects/User'
import { UserLockState } from 'modules/user_data/objects/UserLock'
import { Glyphicon } from 'react-bootstrap'

export default class UserLockCell extends React.Component {
  render () {
    const lock = this.props.user.locks[this.props.lockType]
    if (lock.state === UserLockState.PENDING) {
      return (
        <Glyphicon glyph='refresh' />
      )
    }
    let lockStr = 'Locked'
    let lockCss = 'lock_status_locked'
    if (lock.state === UserLockState.UNLOCKED) {
      lockStr = 'Unlocked'
      lockCss = 'lock_status_unlocked'
    }
    const linkCss = (lock.selected) ? 'lock_status_selected' : 'lock_status'
    return (
      <div>
        <a className={linkCss} onClick={() => { this.props.onSelect(this.props.user, this.props.lockType) }}>
          <Glyphicon glyph={(lock.selected) ? 'check' : 'unchecked'} />
          {' '}
          <span className={lockCss}>
            {lockStr}
          </span>
        </a>
      </div>
    )
  }
}

UserLockCell.propTypes = {
  user: React.PropTypes.instanceOf(User),
  lockType: React.PropTypes.any,
  selectedUserLocks: React.PropTypes.array,
  onSelect: React.PropTypes.func
}
