import React from 'react'
import { Glyphicon } from 'react-bootstrap'
import TableSorter, { TableSortType } from '../objects/TableSorter'

export default class UserTableHeader extends React.Component {

  constructor (props) {
    super(props)
    this.onToggleSort = this.onToggleSort.bind(this)
  }

  onToggleSort () {
    let sorter = this.props.sorter
    if (sorter === null || sorter.id !== this.props.id) {
      sorter = new TableSorter(this.props.id, TableSortType.ASCENDING)
    } else if (sorter.type === TableSortType.ASCENDING) {
      sorter = new TableSorter(this.props.id, TableSortType.DESCENDING)
    } else if (sorter.type === TableSortType.DESCENDING) {
      sorter = new TableSorter()
    }
    this.props.onToggleSort(sorter)
  }

  render () {
    const sorter = this.props.sorter
    let glyphImg
    if (sorter.id === this.props.id) {
      glyphImg = 'sort-by-attributes'
      if (sorter.type === TableSortType.DESCENDING) {
        glyphImg = 'sort-by-attributes-alt'
      }
    }
    let glyph = null
    if (glyphImg !== undefined) {
      glyph = <Glyphicon glyph={glyphImg} />
    }
    return (
      <th>
        <a className='user_header_col' onClick={this.onToggleSort}>
          {this.props.children}
          {' '}
          {glyph}
        </a>
      </th>
    )
  }
}

UserTableHeader.propTypes = {
  id: React.PropTypes.string.isRequired,
  children: React.PropTypes.any,
  sorter: React.PropTypes.instanceOf(TableSorter).isRequired,
  onToggleSort: React.PropTypes.func.isRequired
}
