import { combineReducers } from 'redux'

import {
  REQUEST_USER_TABLE_ROUTE,
  RECEIVE_USER_TABLE_ROUTE,
  RECEIVE_USER_TABLE_ROUTE_ERROR,
  REQUEST_TOGGLE_USER_LOCKS,
  RECEIVE_TOGGLE_USER_LOCKS,
  RECEIVE_TOGGLE_USER_LOCKS_ERROR
} from '../actions'

const loading = (state = true, action) => {
  switch (action.type) {
    case REQUEST_USER_TABLE_ROUTE:
      return true
    case RECEIVE_USER_TABLE_ROUTE:
    case RECEIVE_USER_TABLE_ROUTE_ERROR:
      return false
    default:
      return state
  }
}

const error = (state = null, action) => {
  switch (action.type) {
    default:
      return state
  }
}

const isTogglingUserLocks = (state = false, action) => {
  switch (action.type) {
    case REQUEST_TOGGLE_USER_LOCKS:
      return true
    case RECEIVE_TOGGLE_USER_LOCKS:
    case RECEIVE_TOGGLE_USER_LOCKS_ERROR:
      return false
    default:
      return state
  }
}

export default combineReducers({
  loading,
  error,
  isTogglingUserLocks
})
