import React from 'react'
import DocumentTitle from 'react-document-title'
import { Grid } from 'react-bootstrap'
import './DefaultView.scss'

export default class DefaultView extends React.Component {

  documentTitle () {
    return 'My Document'
  }

  headerTitle () {
    return null
  }

  headerSubtitle () {
    return null
  }

  renderHeader () {
    let header = this.headerTitle()
    if (header === null) {
      return null
    }
    let subtitle = this.headerSubtitle()
    if (subtitle !== null) {
      subtitle = <h3 className='default-view-header-subtitle'><small>{subtitle}</small></h3>
    }
    return (
      <Grid className='default-view-header' fluid>
        <Grid>
          <h1 className='default-view-header-title'>{header}</h1>
          {subtitle}
        </Grid>
      </Grid>
    )
  }

  render () {
    let content = null
    let header = null
    if (this.props.error !== null && this.props.error !== undefined) {
      content = (
        <Grid style={{ marginTop: '40px' }}>
          {this.renderError()}
        </Grid>
      )
    } else if (this.props.loading === true) {
      content = (
        <Grid style={{ marginTop: '40px' }}>
          <div>Loading...</div>
        </Grid>
      )
    } else {
      header = this.renderHeader()
      content = this.renderContent()
    }
    return (
      <DocumentTitle title={this.documentTitle()}>
        <div style={{ marginBottom: '40px' }}>
          {header}
          {content}
        </div>
      </DocumentTitle>
    )
  }
}

DefaultView.propTypes = {
  error: React.PropTypes.any,
  loading: React.PropTypes.bool
}
