provider "aws" {
  region  = "us-west-2"
  profile = "twitch-cape-qe-aws"
  version = "~> 2.0"
}

resource "aws_elastic_beanstalk_application" "heimdall-ui" {
  name        = "heimdall-ui"
  description = "Front End Application to the Heimdall API"
}

module "heimdall-prod" {
  source           = "./modules"
  application_name = aws_elastic_beanstalk_application.heimdall-ui.name
  environment_name = "production"
  r53_name         = var.route_53_fqdn_prod
  elb_sg           = aws_security_group.heimdall_elb.id
  ec2_sg           = aws_security_group.heimdall_ec2.id
  r53_zone         = data.aws_route53_zone.heimdall_xarth.zone_id
}
