# SSL for Grid Dev Auto
resource "aws_acm_certificate" "xarth_cert" {
  domain_name       = var.r53_name
  validation_method = "DNS"

  tags = {
    Service = "heimdall-ui"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL Above
resource "aws_route53_record" "xarth_cert_validation" {
  zone_id = var.r53_zone
  name    = lookup(aws_acm_certificate.xarth_cert.domain_validation_options[0], "resource_record_name")
  type    = lookup(aws_acm_certificate.xarth_cert.domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.xarth_cert.domain_validation_options[0], "resource_record_value")]
}
