// Used for Capturing VPC ID
data "terraform_remote_state" "parent_account_vpc" {
  backend = "s3"
  config = {
    profile = "twitch-cape-qe-aws"
    bucket  = "tf-state-qe"
    key     = "tfstate/qe/terraform/vpc"
    region  = "us-west-2"
  }
}

// Used for gathering Internal CIDRs
data "terraform_remote_state" "parent_account_sgs" {
  backend = "s3"
  config = {
    profile = "twitch-cape-qe-aws"
    bucket  = "tf-state-qe"
    key     = "tfstate/qe/terraform/security-groups"
    region  = "us-west-2"
  }
}

# Security Group for the ELB

resource "aws_security_group" "heimdall_elb" {
  name        = "heimdall_ui_elb"
  description = "Heimdall Elastic Loadbalancer access for Internal Subnet."
  vpc_id      = data.terraform_remote_state.parent_account_vpc.outputs.vpc_id

  tags = {
    Name  = "Heimdall UI ELB"
    Owner = "reichsta"
    Team  = "e2e"
  }
}

# Security group for the EC2 Instances

resource "aws_security_group" "heimdall_ec2" {
  name        = "heimdall_ui_ec2"
  description = "Heimdall Elastic Loadbalancer access for Internal Subnet."
  vpc_id      = data.terraform_remote_state.parent_account_vpc.outputs.vpc_id

  tags = {
    Name  = "Heimdall UI EC2"
    Owner = "reichsta"
    Team  = "e2e"
  }
}

# Rules for the ELB

# Ingress
# Allow Twitch Subnets to connect to 80 and 443
resource "aws_security_group_rule" "http_twitch_subnet_ingress" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "ingress"
  from_port         = 80
  to_port           = 80
  protocol          = "tcp"
  cidr_blocks = data.terraform_remote_state.parent_account_sgs.outputs.twitch_subnets
}

resource "aws_security_group_rule" "http_twitch_subnet_ingress_443" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "ingress"
  from_port         = 443
  to_port           = 443
  protocol          = "tcp"
  cidr_blocks = data.terraform_remote_state.parent_account_sgs.outputs.twitch_subnets
}

# Egress
# Only talk to EC2 Instances on 80 & 443
resource "aws_security_group_rule" "http_elb_egress" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "egress"
  from_port         = 80
  to_port           = 80
  protocol          = "tcp"

  # Only allow egress to Gnosis EC2 Instances
  source_security_group_id = aws_security_group.heimdall_ec2.id
}

resource "aws_security_group_rule" "http_elb_egress_443" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "egress"
  from_port         = 443
  to_port           = 443
  protocol          = "tcp"

  # Only allow egress to Gnosis EC2 Instances
  source_security_group_id = aws_security_group.heimdall_ec2.id
}

# Rules for the EC2 Instances

# Ingress
# Only accept connections from the ELB on 80 & 443
resource "aws_security_group_rule" "http_elb_ingress" {
  security_group_id = aws_security_group.heimdall_ec2.id
  type              = "ingress"
  from_port         = 80
  to_port           = 80
  protocol          = "tcp"

  # Only allow egress from Gnosis ELB Instances
  source_security_group_id = aws_security_group.heimdall_elb.id
}

resource "aws_security_group_rule" "http_elb_ingress_443" {
  security_group_id = aws_security_group.heimdall_ec2.id
  type              = "ingress"
  from_port         = 443
  to_port           = 443
  protocol          = "tcp"

  # Only allow egress from Gnosis ELB Instances
  source_security_group_id = aws_security_group.heimdall_elb.id
}

# Egress
# No restrictions
resource "aws_security_group_rule" "egress_any" {
  security_group_id = aws_security_group.heimdall_ec2.id
  type              = "egress"
  from_port         = 0
  to_port           = 0
  protocol          = "-1"
  cidr_blocks       = ["0.0.0.0/0"]
}

output "heimdall_elb_sg" {
  value = aws_security_group.heimdall_elb.id
}

output "heimdall_ec2_sg" {
  value = aws_security_group.heimdall_ec2.id
}
