# Heimdall

This is a very simple API server that manages QE test accounts used in automation.  It was created to address concurrency issues when automated tests simultaneously try to access the same account during testing.

Whenever an account is needed, tests will query this server to see a list of available accounts.  Accounts are "bucketed" into `UserType` objects.  Each `UserType` has several `User` objects that house the account information.

A `User` object also has two `Lock` objects (one for staging and one for prod).  This object indicates whether or not the associated account is in use or not.  If its state is set, then that means a test is currently using that account, while if not set, then the account is available for test.

Tests will query this server for available accounts, select one, and then lock it while its in use.  It is up to tests to release this lock when they're done with the account.

## Endpoint & Additional Information
If you are looking to utilize Heimdall, and are looking for details (such as available endpoints), see the [Confluence Documentation](https://wiki.twitch.com/display/QE/Heimdall%3A+Test+Account+Manager)

## Local Development

### Prerequisites

Must have configured:

- Git
- Brew
- Rbenv

### First Time Setup

##### Clone repository into directory of your choice.

`git@git.xarth.tv:qe/heimdall.git`

##### Install Ruby Version via Rbenv
```
rbenv install `cat .ruby-version`
```

##### Install MySQL Server

At the time of this writing, we are currently using MySQL 5.6 in Production.
You'll want to use this version to avoid errors installing the mysql gem.

```
brew update
```

```
brew install mysql@5.7
```

As this is an older version, you may need to add it to your path:
```
echo 'export PATH="/usr/local/opt/mysql@5.7/bin:$PATH"'
```

##### Install Gems.

MySQL is required before this step (see above).

`bundle install`

If the mysql gem fails on macOS, try with:
```gem install mysql2 -v '0.4.10' -- --with-ldflags=-L/usr/local/opt/openssl@1.1/lib --with-cppflags=-I/usr/local/opt/openssl@1.1/include```

You may need to change the paths above. You can get the path above by running `brew info openssl` and reading the warning that is posted.

If the ffi gem fails on macOS Catalina, try with:
`gem install ffi -v '1.9.18' -- --with-cflags="-Wno-error=implicit-function-declaration"`

Source: https://stackoverflow.com/questions/64098041/cant-install-ffi-v-1-9-18-on-macos-catalina

##### Start MySQL

To run in the background,

`brew services start mysql@5.7`

For a one-time start:

`mysql.server start`

##### Install MySQL Timezone Support

`mysql_tzinfo_to_sql /usr/share/zoneinfo | mysql -u root mysql`

If you receive warnings, they likely can be ignored.

##### Prepare the Database

`bundle exec rake db:create`

`bundle exec rake db:migrate`

### Running Localhost

Start server:

`bundle exec rails s`

Load Rails Console:

`bundle exec rails c`

or in sandbox:

`bundle exec rails c --sandbox`

### Running Tests
You can run tests locally with:
```
bundle exec rspec
```
