class TeamsController < ApplicationController
  before_action :set_team, except: [:create_team]
  before_action :generate_access_token, only: [:create_team]

  # DELETE  /teams/:id
  def delete
    @team.destroy!
    return head :no_content
  end

  # Creates auth token and updates the params with api_key
  # POST  /teams
  def create_team
    params = team_params
    params[:api_key] = @access_token
    team = Team.create!(params)
    return json_response(team, :created)
  end

  # PUT/PATCH  /teams/:name
  def update
    @team.update!(team_params)
    return json_response(@team)
  end

  # GET /teams/:name
  def get_team
    return json_response(@team)
  end

  # Setting up strict parameters for when we add team creation.
  private def team_params
    return params.permit(:name)
  end

  private def set_team
    @team = Team.find_by!(name: params[:team_name])
  end

  private def generate_access_token
    @access_token = SecureRandom.hex
  end

end
