# app/controllers/user_types_controller.rb
class UserTypesController < ApplicationController
  before_action :set_user_type, except: [:index, :create]

  # GET /types
  def index
    user_types = UserType.all
    return json_response(user_types)
  end

  # POST /types
  def create
    if UserType.exists?(name: user_type_params[:name])
      return json_response({message: 'Validation failed: UserType already exsits'}, :unprocessable_entity)
    else
      user_type = UserType.create!(user_type_params)
      return json_response(user_type, :created)
    end
  end

  # GET /types/:type_name
  def show
    return json_response(@user_type)
  end

  # PUT /types/:type_name
  def update
    @user_type.update!(user_type_params)
    return json_response(@user_type)
  end

  # DELETE /types/:type_name
  def destroy
    @user_type.destroy!
    return head :no_content
  end

  private

  def user_type_params
    return params.permit(:name, :description)
  end

  def set_user_type
    @user_type = UserType.find_by!(name: params[:type_name])
  end
end
