# app/controllers/users_controller.rb
class UsersController < ApplicationController
  before_action :set_user, except: [:index, :index_type, :create]
  before_action :authenticate_token , only: [:create, :update]
  before_action :restrict_access_delete , only: [:destroy]

  # GET /users
  def index
    users = User.all
    return json_response(users)
  end

  # GET /types/:type_name/users
  def index_type
    user_type = UserType.find_by!(name: params[:type_name])
    users = user_type.users
    return json_response(users)
  end

  # POST /types/:type_name/users
  def create
    user_type = UserType.find_by!(name: params[:type_name])
    if user_type.users.exists?(username: user_params[:username])
      return json_response({message: 'Validation failed: User already exsits'}, :unprocessable_entity)
    else
      user_create_params = user_params
      user_create_params[:teams_id] = @team.id
      user = user_type.users.create!(user_create_params)
      return json_response(user, :created)
    end
  end

  # GET /users/:user_name
  def show
    return json_response(@user)
  end

  # PUT /users/:user_name
  def update
    @user.update!(user_params)
    return json_response(@user)
  end

  # DELETE /users/:user_name
  def destroy
    @user.destroy!
    return json_response({message: "Deleted user successfully", user: @user}, :ok)
  end

  private

  def user_params
    return params.permit(:username, :authentication_token)
  end

  def set_user
    @user = User.find_by!(username: params[:user_name])
  end

  # HTTP Token authentication Ex: Authorization: Token token=28d50f0xxxxxxxx
  # Validates the auth token by comparing the user's team id and team's id to which the token belong)
  # Raises Exception when either user/team is not found or user's team does not match the team found using the token
  def restrict_access_delete
    begin
      result = false
      authenticate_or_request_with_http_token do |token, options|
        team = Team.find_by!(api_key: token)
        result = (@user.teams_id == team.id)
      end
    rescue Exception, ActiveRecord::RecordNotFound => e
      render json: {error: "HTTP Token: Access denied. " + e.message}.to_json, status: 401
    end
    return result
  end

  # HTTP Token authentication Ex: Authorization: Token token=28d50f0xxxxxxxx
  # Validates the auth token
  # Raises Exception when either team is not found using the token
  def authenticate_token
    begin
      result = false
      authenticate_or_request_with_http_token do |token, options|
        @team = Team.find_by!(api_key: token)
        if(@team)
          result = true
        end
      end
    rescue Exception, ActiveRecord::RecordNotFound => e
      render json: {error: "HTTP Token: Access denied. " + e.message}.to_json, status: 401
    end
    return result
  end

end
