# app/models/user.rb
class User < ApplicationRecord
  # model association
  belongs_to :user_type
  has_many :locks, dependent: :destroy

  validates :username, presence: true, uniqueness: true
  validates :authentication_token, presence: false, length: { maximum: 800 }
  after_create :create_locks

  def as_json(options = {})
    super(include: { locks: {} })
  end

  def create_locks
    locks.create!(env: 'prod')
    locks.create!(env: 'staging')
  end

  # Returns the existing lock for the given environment, will create
  #   a new lock if there is no existing lock for the environment
  #
  # Note: has somewhat undefined behaviors if somehow multiple locks exist for the same environment
  #
  # @param [String] env
  # @return [Lock]
  def lock(env)
    env = env == 'production' ? 'prod' : env
    locks.select { |lock| lock.env == env }[0] || locks.create!(env: env)
  end
end
