# app/models/user_type.rb
class UserType < ApplicationRecord
  # model association
  has_many :users, dependent: :destroy

  # validations
  validates :name, presence: true, uniqueness: true
  validates_presence_of :description
  
  def as_json(options={})
    super(include: {users: {}})
  end
end
