# config/routes.rb
Rails.application.routes.draw do

  root to: redirect('http://heimdall.xarth.tv')

  # Healthcheck Calls
  get 'healthcheck', to: 'healthcheck#index'

  # -----------------------
  # TYPE RELATED API CALLS
  # -----------------------

  # List all UserType objects
  get 'types', to: 'user_types#index'

  # Display a specific UserType object.
  get 'types/:type_name', to: 'user_types#show'

  # Creates a new UserType object
  post 'types', to: 'user_types#create'

  # Updates an existing UserType object
  patch 'types/:type_name', to: 'user_types#update'
  put 'types/:type_name', to: 'user_types#update'

  # Delete an existing UserType object
  # delete  'types/:type_name', to: 'user_types#destroy'

  # -----------------------
  # USER RELATED API CALLS
  # -----------------------

  # List all User objects.
  get 'users', to: 'users#index'

  # List all User objects for a UserType.
  get 'types/:type_name/users', to: 'users#index_type'

  # Display a specific User object.
  get 'types/:type_name/users/:user_name', to: 'users#show'

  # Create a new User object and associate it with a given UserType.
  # This will also generate the necessary Lock models for 'staging' and 'prod'.
  post 'types/:type_name/users', to: 'users#create'

  # Update an existing User object.
  patch 'types/:type_name/users/:user_name', to: 'users#update'
  put 'types/:type_name/users/:user_name', to: 'users#update'

  # Deletes user based on username
  delete 'types/:type_name/users/:user_name', to: 'users#destroy'

  # Delete an existing User object
  # delete  'types/:type_name/users/:user_name', to: 'users#destroy'

  # -----------------------
  # LOCK RELATED API CALLS
  # -----------------------

  # List all Lock objects.
  get 'locks', to: 'locks#index'

  # List all Lock objects for a given User.
  get 'types/:type_name/users/:user_name/locks', to: 'locks#index_user'

  # Display a specific Lock object.
  get 'types/:type_name/users/:user_name/:env', to: 'locks#show'

  # Locks a user
  put 'types/:type_name/users/:user_name/:env/lock', to: 'locks#lock'

  # Unlocks a user
  put 'types/:type_name/users/:user_name/:env/unlock', to: 'locks#unlock'

  # Returns available User for a given environment.
  put 'types/:type_name/available/:env', to: 'locks#available'
  put 'types/available/:env', to: 'locks#available'

  # -----------------------
  # TEAM RELATED API CALLS
  # -----------------------

  # Display a specific Team object.
  get 'teams/:team_name', to: 'teams#get_team'

  # Creates a new Team  object
  post 'teams', to: 'teams#create_team'

  # Updates an existing Team object
  patch 'teams/:team_name', to: 'teams#update'
  put 'teams/:team_name', to: 'teams#update'
end
