job {
    name "qe-heimdall"
    using 'TEMPLATE-autobuild'

    logRotator {
      daysToKeep(90)
    }

    scm {
      git {
        remote {
          github 'qe/heimdall', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }
        clean true
      }
    }
    wrappers {
      colorizeOutput(colorMap = 'xterm')
      credentialsBinding {
        usernamePassword('AWS_ACCESS_KEY', 'AWS_SECRET_KEY', 'twitch-cape-qe-aws')
      }
      timestamps()
    }
    steps {
      shell './scripts/test/run_tests_in_docker.sh'
      createPassengerArtifact 'heimdall', "\$GIT_COMMIT", 'elasticbeanstalk-us-west-2-425992774280'
    }

    publishers {
      archiveJunit('artifacts/test_report.xml')
      archiveArtifacts {
          pattern('artifacts/test_report.xml')
          onlyIfSuccessful()
          allowEmpty()
      }
    }
}

job {
    name 'qe-heimdall-deploy'
    using 'TEMPLATE-deploy-aws'

    logRotator {
          daysToKeep(90)
    }

    wrappers {
      credentialsBinding {
        usernamePassword('AWS_ACCESS_KEY', 'AWS_SECRET_KEY', 'twitch-cape-qe-aws')
      }
    }

    steps {
      deployElasticBeanstalkArtifact 'heimdall', "\$ENVIRONMENT", "\$GIT_COMMIT"
    }

    publishers {
      postBuildTask {
        task('ERROR: Timed out while waiting for command to Complete.', 'exit 1', true)
        task('ERROR: Failed to deploy application.', 'exit 1', true)
      }
    }
}
