#!/bin/bash

set -e # exit on error

# grab the path of the folder this file is in
parent_path=$( cd "$(dirname "${BASH_SOURCE[0]}")" ; pwd -P )

# Build the image
docker build -t heimdall_test -f "$parent_path/Dockerfile" .

# Run tests, export it to /artifacts
docker run --rm -v "${PWD}/artifacts:/build/output" \
 heimdall_test /bin/sh -c "bundle exec rails db:migrate RAILS_ENV=test; bundle exec rspec --format documentation --format RspecJunitFormatter --out output/test_report.xml"
