require 'rails_helper'

RSpec.describe UsersController, type: :controller do

  describe '#update' do

    let(:user) { FactoryGirl.create(:user) }
    let!(:team) { create(:team) }
    let(:token) { team.api_key }
    let(:headers) { { Authorization: "Token token=#{token}"} }
    it 'accepts an authentication token' do
      request.headers.merge!(headers)
      pre_auth_token = user.authentication_token
      put :update, params: {user_name: user.username,
                            type_name: user.user_type.name,
                            authentication_token: 'foobarupdate'}
      post_auth_token = user.reload.authentication_token
      expect(response).to have_http_status(200)
      expect(pre_auth_token).not_to eq(post_auth_token)
    end

  end
end
