require 'rails_helper'

RSpec.describe Team, type: :model do
  it { should validate_presence_of(:name) }
  it 'should fail if another record is already created with the same team name' do
    name = 'Team foo'
    FactoryGirl.create(:team, name: name)
    type2 = FactoryGirl.build(:team, name: name)
    expect(type2).not_to be_valid
  end
end
