require 'rails_helper'

RSpec.describe User, type: :model do
  it { should belong_to(:user_type) }
  it { should have_many(:locks).dependent(:destroy) }
  it { should validate_presence_of(:username) }

  it 'should fail if another record is already created with the same name' do
    username = 'foobar'
    FactoryGirl.create(:user, username: username)
    user2 = FactoryGirl.build(:user, username: username)
    expect(user2).not_to be_valid
  end

  describe 'authentication_token' do
    it 'saves to the model' do
      auth_token = '%22authToken%22:%22foobarfoobarfoobarfoobar%22'
      b = FactoryGirl.create(:user, authentication_token: auth_token)
      expect(b).to be_valid
      expect(b).to have_attributes(authentication_token: auth_token)
    end

    it 'is not required' do
      b = FactoryGirl.build(:user, authentication_token: nil)
      expect(b).to be_valid
    end

    it 'cannot be longer than 800 characters' do
      limit = 800
      auth_token_long  = 'a' * (limit + 1)
      auth_token_short = 'a' * (limit)

      a = FactoryGirl.build(:user, authentication_token: auth_token_long)
      expect(a).not_to be_valid

      b = FactoryGirl.create(:user, authentication_token: auth_token_short)
      expect(b).to be_valid
    end
  end
end
