require 'rails_helper'

RSpec.describe UserType, type: :model do
  it { should have_many(:users).dependent(:destroy) }
  it { should validate_presence_of(:name) }

  it 'should fail if another record is already created with the same name' do
    name = 'foobar'
    FactoryGirl.create(:user_type, name: name)
    type2 = FactoryGirl.build(:user_type, name: name)
    expect(type2).not_to be_valid
  end
end
