# Terraform Configuration

Heimdall's Elastic Beanstalk, RDS and Route53 resources are configured via Terraform.

There are two AWS accounts you must have access to:
- twitch-aws
  - Route53 Configuration
  - Contact #scieng on slack to be added
- twitch-cape-qe-aws
  - Everything else
  - Contact #qe-automation to be added

### Version

This has been configured with Terraform [v0.11.14](https://releases.hashicorp.com/terraform/0.11.14/)

### Setting Up Credentials
This terraform configuration takes advantage of AWS Credential Files.

Add the following to ~/.aws/credentials
```
[twitch-cape-qe-aws]
aws_access_key_id     = MY_TWITCH_CAPE_QE_ID
aws_secret_access_key = MY_TWITCH_CAPE_QE_KEY
[twitch-aws]
aws_access_key_id     = MY_TWITCH_AWS_ID
aws_secret_access_key = MY_TWITCH_AWS_KEY
```

### Running Terraform

Three steps:
1) `terraform init`
2) `terraform plan`
3) `terraform apply`

##### Terraform Init
Before running any configuration, you must run `terraform init`

Terraform keeps track of the state of our infrastructure via "State" files, and uploads them to S3. By running `terraform init`, you'll tell Terraform to look in that location.

After you run this, you should not need to configure it again

##### Plan

This is the step that'll look at state, and see what's different. It won't make any of the changes.

You'll want to make sure to look through this and make sure it matches the changes you're making.

It's recommended to run `terraform plan` before making any changes to the files, just to make sure nothing is funky with the state.

##### Apply

Here your changes are actually made and the APIs for AWS are actually called.
