# Health Alarm
resource "aws_cloudwatch_metric_alarm" "env_health" {
  alarm_name          = "${aws_elastic_beanstalk_environment.heimdall.name}-environment-health"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "EnvironmentHealth"
  namespace           = "AWS/ElasticBeanstalk"
  period              = "60"
  statistic           = "Maximum"
  threshold           = var.env_health_threshold
  dimensions = {
    EnvironmentName = aws_elastic_beanstalk_environment.heimdall.name
  }
  alarm_description = "This alarm monitors a beanstalk environment's health by healthcode. 0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)"
  actions_enabled   = var.alarms_enabled
  alarm_actions     = [var.sns_arn] # Trigger PD Incident
  ok_actions        = [var.sns_arn] # Resolve PD Incident
}

resource "aws_cloudwatch_metric_alarm" "cpu_util" {
  alarm_name          = "${aws_elastic_beanstalk_environment.heimdall.name}-cpu-util"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "CPUUtilization"
  namespace           = "AWS/EC2"
  period              = "60"
  statistic           = "Maximum"
  threshold           = "80"
  dimensions = {
    AutoScalingGroupName = aws_elastic_beanstalk_environment.heimdall.autoscaling_groups[0]
  }
  alarm_description = "This alarm monitors CPU Utilization"
  actions_enabled   = var.alarms_enabled
  alarm_actions     = [var.sns_arn] # Trigger PD Incident
  ok_actions        = [var.sns_arn] # Resolve PD Incident
}

resource "aws_cloudwatch_metric_alarm" "disk_util" {
  alarm_name          = "${aws_elastic_beanstalk_environment.heimdall.name}-disk-util"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "RootFilesystemUtil"
  namespace           = "AWS/ElasticBeanstalk"
  period              = "300"
  statistic           = "Maximum"
  threshold           = "90"
  dimensions = {
    EnvironmentName = aws_elastic_beanstalk_environment.heimdall.name
  }
  alarm_description = "This alarm monitors Disk Utilization"
  actions_enabled   = var.alarms_enabled
  alarm_actions     = [var.sns_arn] # Trigger PD Incident
  ok_actions        = [var.sns_arn] # Resolve PD Incident
}

resource "aws_cloudwatch_metric_alarm" "mem_util" {
  alarm_name          = "${aws_elastic_beanstalk_environment.heimdall.name}-mem-util"
  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "mem_available_percent"
  namespace           = "Heimdall"
  period              = "300"
  statistic           = "Minimum"
  threshold           = "20"
  dimensions = {
    AutoScalingGroupName = aws_elastic_beanstalk_environment.heimdall.autoscaling_groups[0]
  }
  alarm_description = "This alarm monitors Available Memory"
  actions_enabled   = var.alarms_enabled
  alarm_actions     = [var.sns_arn] # Trigger PD Incident
  ok_actions        = [var.sns_arn] # Resolve PD Incident
}

resource "aws_cloudwatch_metric_alarm" "p90" {
  alarm_name          = "${aws_elastic_beanstalk_environment.heimdall.name}-p90-latency"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "ApplicationLatencyP90"
  namespace           = "AWS/ElasticBeanstalk"
  period              = "60"
  statistic           = "Maximum"
  threshold           = "2" // 2 seconds
  dimensions = {
    EnvironmentName = aws_elastic_beanstalk_environment.heimdall.name
  }
  alarm_description = "This alarm monitors P90 Latency"
  actions_enabled   = var.alarms_enabled
  alarm_actions     = [var.sns_arn] # Trigger PD Incident
  ok_actions        = [var.sns_arn] # Resolve PD Incident
}
