resource "aws_route53_record" "heimdall_xarth" { // Main DNS Record
  zone_id = var.r53_zone
  name    = var.dns_record_name
  type    = "CNAME"
  ttl     = "300"
  records = [aws_elastic_beanstalk_environment.heimdall.cname]
}

resource "aws_route53_record" "heimdall_xarth_nexus" {
  count   = var.nexus_dns_name != "" ? 1 : 0 // create if a nexus hostname was provided
  zone_id = var.r53_zone
  name    = "${var.dns_record_name}-nexus"
  type    = "CNAME"
  ttl     = "300"
  records = [var.nexus_dns_name]
}

output "fqdn" {
  value = aws_route53_record.heimdall_xarth.fqdn
}
