resource "aws_acm_certificate" "xarth_cert" {
  domain_name       = "${var.dns_record_name}.heimdall.xarth.tv"
  validation_method = "DNS"

  tags = {
    Service = "heimdall"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL Above
resource "aws_route53_record" "xarth_cert_validation" {
  zone_id = var.r53_zone
  name = lookup(aws_acm_certificate.xarth_cert.domain_validation_options[0], "resource_record_name")
  type = lookup(aws_acm_certificate.xarth_cert.domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.xarth_cert.domain_validation_options[0], "resource_record_value")]
}

// TODO - Remove this record when all clients can use Nexus Authentication within their frameworks
// This is a temporary way for us to allow clients to onboard to the new Nexus authentication
//   while keeping the existing intact
resource "aws_acm_certificate" "xarth_cert_nexus" {
  domain_name       = "${var.dns_record_name}-nexus.heimdall.xarth.tv"
  validation_method = "DNS"
  subject_alternative_names = [
    "${var.dns_record_name}.heimdall.xarth.tv"
  ]

  tags = {
    Service = "heimdall"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL Above
resource "aws_route53_record" "xarth_cert_validation_nexus" {
  zone_id = var.r53_zone
  name = lookup(aws_acm_certificate.xarth_cert_nexus.domain_validation_options[0], "resource_record_name")
  type = lookup(aws_acm_certificate.xarth_cert_nexus.domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.xarth_cert_nexus.domain_validation_options[0], "resource_record_value")]
}
