variable "sns_arn" {}

/*
The threshold of the Beanstalk Environment at which it alarms
0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)
*/
variable "env_health_threshold" { // The threshold of the Beanstalk Environment at which it alarms
  default = "20" // 0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)
}

// Whether to enable Cloudwatch Alarms (false for things like staging)
variable "alarms_enabled" {
  default = "true"
}

variable "vpc_id" {
  default = "vpc-25d89842"
}

variable "subnets" {
  default = [
    "subnet-cf9a03a8", // Private A
    "subnet-b3b102fa", // Private B
    "subnet-c83d2990", // Private C
  ]
}

variable "r53_zone" {} // Route53 Zone ID for the DNS Record
variable "dns_record_name" {} // The name for the DNS Record (<NAME>.heimdall.xarth.tv)

// Provide this if you've created a Nexus Stack and want to create a Nexus DNS Record for Heimdall
// Optional Variable. If you don't provide it, a nexus dns record won't be created
// Example: nexus-Nexus-1G44W9H79292M-616802512.us-west-2.elb.amazonaws.com
variable "nexus_dns_name" {
  default = ""
}
