variable "twitch_subnets" {
  default = "10.0.0.0/8,192.16.64.0/21,199.9.248.0/21,185.42.204.0/22,127.0.0.1/32,38.99.10.97/32,192.168.0.0/16,45.113.128.0/22,103.53.48.0/22,192.108.239.0/24,23.160.0.0/24,52.223.192.0/18"
}

# Security Group for the ELB

resource "aws_security_group" "heimdall_elb" {
  name        = "heimdall_elb"
  description = "Heimdall Elastic Loadbalancer access for Internal Subnet."
  vpc_id      = "vpc-25d89842"

  tags = {
    Name  = "Heimdall ELB"
    Owner = "reichsta"
    Team  = "e2e"
  }
}

# Security group for the EC2 Instances

resource "aws_security_group" "heimdall_ec2" {
  name        = "heimdall_ec2"
  description = "Heimdall Elastic Loadbalancer access for Internal Subnet."
  vpc_id      = "vpc-25d89842"

  tags = {
    Name  = "Heimdall EC2"
    Owner = "reichsta"
    Team  = "e2e"
  }
}

# Security Group for the Proxy Instance
resource "aws_security_group" "proxy" {
  name   = "heimdall_proxy"
  vpc_id = var.vpc_id
  ingress {
    from_port = 0
    protocol  = "-1"
    to_port   = 0
    self      = true
  }
  egress {
    from_port = 0 // allow all outbound

    protocol    = "-1"
    to_port     = 0
    cidr_blocks = ["0.0.0.0/0"]
  }
}

# Rules for the ELB

# Ingress
# Allow Twitch Subnets to connect to 80 and 443
resource "aws_security_group_rule" "http_twitch_subnet_ingress" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "ingress"
  from_port         = 80
  to_port           = 80
  protocol          = "tcp"
  cidr_blocks       = split(",", var.twitch_subnets)
}

resource "aws_security_group_rule" "https_twitch_subnet_ingress" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "ingress"
  from_port         = 443
  to_port           = 443
  protocol          = "tcp"
  cidr_blocks       = split(",", var.twitch_subnets)
}

# Allow connections from Proxy Instance
resource "aws_security_group_rule" "http_heimdall_proxy" {
  security_group_id        = aws_security_group.heimdall_elb.id
  type                     = "ingress"
  from_port                = 80
  to_port                  = 80
  protocol                 = "tcp"
  source_security_group_id = aws_security_group.proxy.id
}

# Egress
# Only talk to EC2 Instances
resource "aws_security_group_rule" "http_elb_egress" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "egress"
  from_port         = 80
  to_port           = 80
  protocol          = "tcp"

  # Only allow egress to Gnosis EC2 Instances
  source_security_group_id = aws_security_group.heimdall_ec2.id
}

resource "aws_security_group_rule" "https_elb_egress" {
  security_group_id = aws_security_group.heimdall_elb.id
  type              = "egress"
  from_port         = 443
  to_port           = 443
  protocol          = "tcp"

  # Only allow egress to Gnosis EC2 Instances
  source_security_group_id = aws_security_group.heimdall_ec2.id
}

# Rules for the EC2 Instances

# Ingress
# Only accept connections from the ELB
resource "aws_security_group_rule" "http_elb_ingress" {
  security_group_id = aws_security_group.heimdall_ec2.id
  type              = "ingress"
  from_port         = 80
  to_port           = 80
  protocol          = "tcp"

  # Only allow egress from Gnosis ELB Instances
  source_security_group_id = aws_security_group.heimdall_elb.id
}

resource "aws_security_group_rule" "https_elb_ingress" {
  security_group_id        = aws_security_group.heimdall_ec2.id
  type                     = "ingress"
  from_port                = 443
  to_port                  = 443
  protocol                 = "tcp"
  source_security_group_id = aws_security_group.heimdall_elb.id
}

# Egress
# No restrictions
resource "aws_security_group_rule" "egress_any" {
  security_group_id = aws_security_group.heimdall_ec2.id
  type              = "egress"
  from_port         = 0
  to_port           = 0
  protocol          = "-1"
  cidr_blocks       = ["0.0.0.0/0"]
}

output "heimdall_elb_sg" {
  value = aws_security_group.heimdall_elb.id
}

output "heimdall_ec2_sg" {
  value = aws_security_group.heimdall_ec2.id
}
