resource "aws_sns_topic" "heimdall" {
  name = "heimdall-alerts"
}

# Subscribe SNS Topic to PagerDuty
# Allows Incidents to be triaged to PagerDuty
# https://twitchoncall.pagerduty.com/service-directory/PBKLVAJ
resource "aws_sns_topic_subscription" "pagerduty" {
  topic_arn              = aws_sns_topic.heimdall.arn
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/10e62058fd4c4901d0b1b6fdf1ae7183/enqueue"
  endpoint_auto_confirms = true
}

output "sns_arn" {
  value = aws_sns_topic.heimdall.arn
}
