variable "heimdall_db_password" { # IMPORTANT: Must be set in bash_profile. export TF_VAR_heimdall_db_password=MY_PASSWORD
}

variable "twitch_subnets" {
  default = "10.0.0.0/8,192.16.64.0/21,199.9.248.0/21,185.42.204.0/22,127.0.0.1/32,38.99.10.97/32,192.168.0.0/16,45.113.128.0/22,103.53.48.0/22,192.108.239.0/24,23.160.0.0/24,52.223.192.0/18"
}

module "heimdall_production" {
  source                       = "./modules"
  name                         = "heimdallproduction"
  instance_class               = "db.t2.micro"
  db_password                  = var.heimdall_db_password
  security_group               = aws_security_group.heimdall_rds.id
  owner                        = "reichsta"
  snapshot_id                  = "heimdall-6-22-17-t15-26"
  multi_az                     = false
  enable_read_replica          = true
  replica_db_subnet_group_name = aws_db_subnet_group.heimdall_us_east_1.id
  replica_security_group       = aws_security_group.heimdall_rds_replica.id

  providers = {
    aws           = aws
    aws.us-east-1 = aws.us-east-1
  }
}

output "production_address" {
  value = module.heimdall_production.address
}

output "production_port" {
  value = module.heimdall_production.port
}

output "production_name" {
  value = module.heimdall_production.name
}

module "heimdall_staging" {
  source         = "./modules"
  name           = "heimdallstaging"
  instance_class = "db.t2.micro"
  db_password    = var.heimdall_db_password
  security_group = aws_security_group.heimdall_rds.id
  owner          = "reichsta"

  providers = {
    aws           = aws
    aws.us-east-1 = aws.us-east-1
  }
}

output "staging_address" {
  value = module.heimdall_staging.address
}

output "staging_port" {
  value = module.heimdall_staging.port
}

output "staging_name" {
  value = module.heimdall_staging.name
}
