variable name {}
variable instance_class {}
variable db_password {}
variable security_group {}
variable owner {}

variable snapshot_id {
  default = ""
}

variable engine_version {
  default = "5.7.26"
}

// indicates whether the DB instance is a Multi-AZ deployment
variable "multi_az" {
  default = false
}

##########################
# Read Replica Variables #
##########################
// whether to enable read replica
variable "enable_read_replica" {
  default = false
}

// The Subnet Group Name to use for the Read Replica. Note, enable_read_replica must equal true
variable replica_db_subnet_group_name {
  default = ""
}

// The Security Group ID to use for the Read Replica. Note, enable_read_replica must equal true
variable replica_security_group {
  default = ""
}

########################
# Resource Declaration #
########################

// Primary Database
resource "aws_db_instance" "rds_db" {
  identifier              = var.name
  allocated_storage       = 5
  engine                  = "mysql"
  engine_version          = var.engine_version
  instance_class          = var.instance_class
  username                = "admin"
  password                = var.db_password
  vpc_security_group_ids  = [var.security_group]
  db_subnet_group_name    = "main"
  parameter_group_name    = "default.mysql5.7"
  port                    = 3306
  publicly_accessible     = false
  multi_az                = var.multi_az
  storage_type            = "standard"
  backup_retention_period = 4
  snapshot_identifier     = var.snapshot_id
  final_snapshot_identifier = "${var.name}-final-before-destroy"

  tags = {
    Name = "${var.name} RDS"
    Owner = var.owner
    Repository = "qe/heimdall"
  }
}

// Read Replica in another region for disaster recovery purposes
// Only creates if module is given enable_read_replica=true
resource "aws_db_instance" "rds_db_replica" {
  provider                = aws.us-east-1
  count                   = var.enable_read_replica ? 1 : 0 // only create if enable_read_replica == true
  identifier              = var.name
  replicate_source_db     = aws_db_instance.rds_db.arn
  engine_version          = var.engine_version
  instance_class          = var.instance_class
  vpc_security_group_ids  = [var.replica_security_group]
  db_subnet_group_name    = var.replica_db_subnet_group_name
  parameter_group_name    = "default.mysql5.7"
  port                    = 3306
  publicly_accessible     = false
  skip_final_snapshot     = true // the primary will have a final snapshot

  tags = {
    Name = "${var.name} RDS Read Replica"
    Owner = var.owner
    Repository = "qe/heimdall"
  }
}

output "address" {
  value = aws_db_instance.rds_db.address
}

output "port" {
  value = aws_db_instance.rds_db.port
}

output "name" {
  value = aws_db_instance.rds_db.identifier
}
