variable "sg_name" {
  default = "heimdall_rds"
}

// us-west-2
resource "aws_security_group" "heimdall_rds" {
  name        = var.sg_name
  description = "Heimdall DB Connection"
  vpc_id      = "vpc-25d89842"

  ingress {
    from_port   = 3306
    to_port     = 3306
    protocol    = "tcp"
    cidr_blocks = []
    self        = true
  }

  ingress {
    from_port   = 3306
    to_port     = 3306
    protocol    = "tcp"
    cidr_blocks = split(",", var.twitch_subnets)
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags = {
    Name       = "Heimdall RDS"
    Repository = "qe/heimdall"
  }
}

// us-east-1
resource "aws_security_group" "heimdall_rds_replica" {
  provider    = aws.us-east-1
  name        = var.sg_name
  description = "Heimdall DB Connection"
  vpc_id      = data.aws_vpc.us_east_1.id

  ingress {
    from_port   = 3306
    to_port     = 3306
    protocol    = "tcp"
    cidr_blocks = []
    self        = true
  }

  ingress {
    from_port   = 3306
    to_port     = 3306
    protocol    = "tcp"
    cidr_blocks = split(",", var.twitch_subnets)
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags = {
    Name       = "Heimdall RDS"
    Repository = "qe/heimdall"
  }
}
